!============================================================================
! subroutine remesh_tracer
! Relocates the element a tracer belongs to, after a remeshing process
! Olive 3/08
!============================================================================

subroutine remesh_tracer
include 'precision.inc'
include 'params.inc'
include 'arrays.inc'

i=1
do while (cord(1,i,1)-xt .lt. 0)       ! sweeps the grid horizontally
i=i+1
end do
i_elm=i-1

j=1
do while (cord(j,i-1,2)-yt .gt. 0)       ! sweeps the left side of the column 
j=j+1                                    ! containing the tracer vertically
end do
jl=j-1 ! now we know the tracer is right below the jl node

j=1
do while (cord(j,i,2)-yt .gt. 0)       ! sweeps the right side of the column 
j=j+1                                  ! containing the tracer vertically
end do
jr=j-1 ! now we know the tracer is right below the jr node



if (jr .eq. jl) then   ! we know the tracer is below the whole segment
j_elm=jl
else

! we have to interpolate the equation of the segment separating the two elements
! and deduce the y coordinate corresponding to xt: ysep

ysep=cord(jl,i_elm,2)+((cord(jr,i_elm+1,2)-cord(jl,i_elm,2))/(cord(jr,i_elm+1,1) &
-cord(jl,i_elm,1)))*(xt-cord(jl,i_elm,1))

if (yt .lt. ysep) then
j_elm=jl
else
j_elm=jl-1
end if

end if

!write(*,*) 'new element for tracer',i_elm,j_elm
end

