!============================================================================
! subroutine remesh_surf (modified from remesh_tracer, with a chain of markers)
! Relocates the elements the surface belongs to, after every time step
! and after a remeshing process
! de Sagazan 6/18
!============================================================================

subroutine remesh_surf
include 'precision.inc'
include 'params.inc'
include 'arrays.inc'
integer k

do k=1,nesurf

i=1
do while (cord(1,i,1)-coord_surf(k,1) .lt. 0)       ! sweeps the grid horizontally
i=i+1
end do
el_surf(k,1)=i-1

j=1
do while (cord(j,i-1,2)-coord_surf(k,2) .gt. 0) ! sweeps the left side of the column 
j=j+1                                           ! containing the tracer vertically
end do
jl=j-1 ! now we know the tracer is right below the jl node

j=1
do while (cord(j,i,2)-coord_surf(k,2) .gt. 0)   ! sweeps the right side of the column 
j=j+1                                           ! containing the tracer vertically
end do
jr=j-1 ! now we know the tracer is right below the jr node



if (jr .eq. jl) then   ! we know the tracer is below the whole segment
el_surf(k,2)=jl
else

! we have to interpolate the equation of the segment separating the two elements
! and deduce the y coordinate corresponding to the new coord_surf(k,1): ysep

ysep=cord(jl,el_surf(k,1),2)+((cord(jr,el_surf(k,1)+1,2)-cord(jl,el_surf(k,1),2))/(cord(jr,el_surf(k,1)+1,1) &
-cord(jl,el_surf(k,1),1)))*(coord_surf(k,1)-cord(jl,el_surf(k,1),1))

if (coord_surf(k,2) .lt. ysep) then
el_surf(k,2)=jl
else
el_surf(k,2)=jl-1
end if

end if

end do
end

