!============================================================================
! subroutine interp_surf
! Reinterpolating the sedimentation surface every time step
! de Sagazan 9/18
!============================================================================

subroutine interp_surf
include 'precision.inc'
include 'params.inc'
include 'arrays.inc'
integer i_new, i_old, k

! Interpolating the elements
coord_surf_old(:,:)=coord_surf(:,:)
coord_surf(:,1)=absc_init(:) ! Fixing the horizontal positions back to original
i_old=1
do i_new=1,nesurf ! Selecting one element of the "new" surface at a time
	do while(coord_surf(i_new,1) .gt. coord_surf_old(i_old+1,1)) ! Determining between which elements of the old surface it has to be interpolated
		i_old=i_old+1
	end do
	coord_surf(i_new,2) = coord_surf_old(i_old,2) + ( (coord_surf_old(i_old+1,2)-coord_surf_old(i_old,2)) / (coord_surf_old(i_old+1,1)&
-coord_surf_old(i_old,1)) ) * (coord_surf(i_new,1)-coord_surf_old(i_old,1))
end do

! Finding which elements the new vector corresponds to ==> CALL REMESH_SURF

end subroutine
