!============================================================================
! subroutine init_tracer
! Initial position of tracer
! Olive 3/08
!============================================================================

subroutine init_tracer
include 'precision.inc'
include 'params.inc'
include 'arrays.inc'


xt=xtinit
yt=ytinit
write(*,*) 'initial position of tracer (km)',xt,yt
! tests for debugging
co1=cord(1,1,1)
co2=cord(1,114,1)
write(*,*) co1,co2

!======================================================
! locating the initial element the tracer belongs to...
!======================================================

ii=1
do while (cord(1,ii,1)-xt.lt.0)       ! sweeps the grid horizontally
ii=ii+1
end do

jj=1
do while (cord(jj,ii-1,2)-yt.gt.0)       ! sweeps the grid vertically
jj=jj+1
end do

! for remeshing, we will need another test based on (cord(jj,ii,2)-yt .lt. 0) 
! and, if necessary, interpolate the equation separating two elements
      
i_elm=ii-1
j_elm=jj-1

write(*,*) 'found element',i_elm,j_elm

return
end
