!============================================================================
! subroutine init_surf
! Initial position of sedimentaiton surface
! de Sagazan 6/18
!============================================================================

subroutine init_surf
include 'precision.inc'
include 'params.inc'
include 'arrays.inc'
real delta_x

!======================================================
! Initializing the tracers of the crust-sediment surface
! (in xy coordinates)
!======================================================

delta_x = (cord(1,nx,1) - cord(1,1,1))/(nesurf-1)
do i=1,nesurf
coord_surf(i,1)=cord(1,1,1) + (i-1)*delta_x
coord_surf(i,2)=cord(1,1,2) - 10 ! The surface is initialized 10 meters below topography

absc_init(i)=coord_surf(i,1) ! Saving the initial horizontal positions of the tracers
end do

!======================================================
! locating the initial elements the tracers belong to
! (in (jj,ii) coordinates)
!======================================================

do i=1,nesurf

ii=1
do while (cord(1,ii,1)-coord_surf(i,1).lt.0)       ! sweeps the grid horizontally
ii=ii+1
end do

!jj=1
!do while (cord(jj,ii-1,2)-coord_surf(i,2).gt.0) ! sweeps the grid vertically
!jj=jj+1                                         ! NOT NEEDED: the sed-basement surface
!end do                                          ! initially corresponds to the topo


! NB: for remeshing, we will need another test based on (cord(jj,ii,2)-yt .lt. 0) 
! to prevent "underwater erosion", and, if necessary, interpolate the equation
! separating two elements

!======================================================
! assigning tracer i of the surface to element (jj,ii)
!======================================================
      
el_surf(i,1)=ii-1
el_surf(i,2)=1      ! Initial topography => top element
end do

!======================================================
! Visualizing element coordinates in the terminal
!======================================================

!do i=1,nesurf
!print*,i,coord_surf(i,:),"/",el_surf(i,:)
!end do
!print*,nesurf


return
end
