!============================================================================
! subroutine cut_M
! changes the brittle and ductile values of M linearly through time at a given time step
! Olive 5/08
!============================================================================

subroutine cut_M
include 'precision.inc'
include 'params.inc'
include 'arrays.inc'

! seconds in a year
sec_year = 3.1558e+7
timeMYR=(1e-6)*time/sec_year
whencut2=whencut+Dtc
! Dtc = length of transition period (Myr)


if ((timeMYR .gt. whencut) .AND. (timeMYR .lt. whencut2)) then
    rate_inject_brittle=rate_inject_brittle2
    rate_inject_ductile=rate_inject_brittle2
else if (timeMYR .gt. whencut2) then
    rate_inject_brittle=2.2e-10
    rate_inject_ductile=2.2e-10
end if


if( mod(nloop,5000) .eq. 0 ) then
   ! write(*,'(a19,i12,f10.3)') 'nloop, melt=',nloop,rate_inject_brittle/2.2e-10/2
    write(*,'(a19,i12,f10.3)') 'nloop, melt (kyr)=',nloop, rate_inject_brittle/2.2e-10/2 
    write(*,'(a19,i12,f10.3)') 'nloop, duct (kyr)=',nloop, rate_inject_ductile2/2.2e-10/2  
    !write(*,'(a19,i12,f10.3)') 'nloop, time (kyr)=',nloop, time/sec_year/1.e+3
endif

end
